<!-- Breadcrumb Section -->
<section class="z-index-2 position-relative pb-2 mb-12">
    <div class="bg-body-secondary mb-3">
        <div class="container">
            <nav class="py-4 lh-30px" aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center py-1 mb-0">
                    <li class="breadcrumb-item"><a title="Home" href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item"><a title="Shop" href="<?=base_url('products')?>">Shop</a></li>
                    <?php if($product->category_name): ?>
                        <li class="breadcrumb-item"><a title="<?=$product->category_name?>" href="<?=base_url('products?category='.$product->categoryUnique)?>"><?=$product->category_name?></a></li>
                    <?php endif; ?>
                    <li class="breadcrumb-item active" aria-current="page"><?=$product->name?></li>
                </ol>
            </nav>
        </div>
    </div>
</section>

<!-- Product Details Section -->
<section class="container pt-6 pb-13 pb-lg-20">
    <div class="row">
        <!-- Product Gallery -->
        <div class="col-md-6 pe-lg-13">
            <div class="row">
                <!-- Thumbnails -->
                <div class="col-xl-2 pe-xl-0 order-1 order-xl-0 mt-5 mt-xl-0">
                    <div id="vertical-slider-thumb" class="slick-slider slick-slider-thumb ps-1 ms-n3 me-n4 mx-xl-0" 
                         data-slick-options='{"arrows":false,"asNavFor":"#vertical-slider-slides","dots":false,"focusOnSelect":true,"responsive":[{"breakpoint":1260,"settings":{"vertical":false}}],"slidesToShow":4,"vertical":true}'>
                        <!-- Main product image thumbnail -->
                        <img src="<?=PRODUCT_ASSETS_URL.$product->image?>" class="cursor-pointer mx-3 mx-xl-0 px-0 mb-xl-7" width="75" height="100" alt="<?=$product->name?>">
                        <!-- Additional photos thumbnails -->
                        <?php if($photos): foreach($photos as $photo): ?>
                            <img src="<?=PRODUCT_ASSETS_URL.$photo->photo?>" class="cursor-pointer mx-3 mx-xl-0 px-0 mb-xl-7" width="75" height="100" alt="<?=$product->name?>">
                        <?php endforeach; endif; ?>
                    </div>
                </div>
                
                <!-- Main Slider -->
                <div class="col-xl-10 ps-xl-8 pe-xl-0 order-0 order-xl-1">
                    <div id="vertical-slider-slides" class="slick-slider slick-slider-arrow-inside slick-slider-dots-inside slick-slider-dots-light g-0" 
                         data-slick-options='{"arrows":false,"asNavFor":"#vertical-slider-thumb","dots":false,"slidesToShow":1,"vertical":true}'>
                        <!-- Main product image -->
                        <a href="<?=PRODUCT_ASSETS_URL.$product->image?>" data-gallery="product-gallery" data-thumb-src="<?=PRODUCT_ASSETS_URL.$product->image?>">
                            <img src="<?=PRODUCT_ASSETS_URL.$product->image?>" width="540" height="720" class="h-auto w-100" alt="<?=$product->name?>">
                        </a>
                        <!-- Additional photos -->
                        <?php if($photos): foreach($photos as $photo): ?>
                            <a href="<?=PRODUCT_ASSETS_URL.$photo->photo?>" data-gallery="product-gallery" data-thumb-src="<?=PRODUCT_ASSETS_URL.$photo->photo?>">
                                <img src="<?=PRODUCT_ASSETS_URL.$photo->photo?>" width="540" height="720" class="h-auto w-100" alt="<?=$product->name?>">
                            </a>
                        <?php endforeach; endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Product Info -->
        <div class="col-md-6 pt-md-0 pt-10">
            <!-- Price -->
            <p class="d-flex align-items-center mb-6">
                <?php if($product->discount_percentage): ?>
                    <span class="text-decoration-line-through"><?=currency_main_symbol($product->amount, 1)?></span>
                    <span class="fs-18px text-body-emphasis ps-6 fw-bold"><?=currency_main_symbol($product->amount, 1, true, $product->discount_percentage)?></span>
                    <span class="badge text-bg-primary fs-6 fw-semibold ms-7 px-6 py-3"><?=$product->discount_percentage?>% OFF</span>
                <?php else: ?>
                    <span class="fs-18px text-body-emphasis fw-bold"><?=currency_main_symbol($product->amount, 1)?></span>
                <?php endif; ?>
            </p>
            
            <!-- Product Title -->
            <h1 class="mb-4 pb-2 fs-4"><?=$product->name?></h1>
            
            <!-- Rating -->
            <?php if($total_reviews > 0): ?>
                <div class="d-flex align-items-center fs-15px mb-6">
                    <p class="mb-0 fw-semibold text-body-emphasis"><?=number_format($average_rating, 2)?></p>
                    <div class="d-flex align-items-center fs-12px justify-content-center mb-0 px-6 rating-result">
                        <div class="rating">
                            <div class="empty-stars">
                                <?php for($i = 0; $i < 5; $i++): ?>
                                    <span class="star">
                                        <svg class="icon star-o"><use xlink:href="#star-o"></use></svg>
                                    </span>
                                <?php endfor; ?>
                            </div>
                            <div class="filled-stars" style="width: <?=($average_rating / 5) * 100?>%">
                                <?php for($i = 0; $i < 5; $i++): ?>
                                    <span class="star">
                                        <svg class="icon star text-primary"><use xlink:href="#star"></use></svg>
                                    </span>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>
                    <a href="#reviews-section" class="border-start ps-6 text-body">Read <?=$total_reviews?> review<?=$total_reviews > 1 ? 's' : ''?></a>
                </div>
            <?php endif; ?>
            
            <!-- Short Description -->
            <?php if($product->short_description): ?>
                <p class="fs-15px mb-7"><?=$product->short_description?></p>
            <?php endif; ?>
            
            <!-- Pre-Order Form -->
            <form id="preOrderForm" class="product-info-custom">
                <input type="hidden" name="productUnique" value="<?=$product->productUnique?>">
                
                <!-- Size Selection -->
                <?php if($sizes && count($sizes) > 0): ?>
                    <div class="form-group shop-swatch mb-7 d-flex align-items-center">
                        <span class="fw-semibold text-body-emphasis me-7">Size: </span>
                        <ul class="list-inline d-flex justify-content-start mb-0 flex-wrap">
                            <?php foreach($sizes as $index => $size): ?>
                                <li class="list-inline-item me-4 mb-2 fw-semibold">
                                    <input type="radio" id="size_<?=$size->sizeUnique?>" name="size" value="<?=$size->sizeUnique?>" class="product-info-size d-none" <?=$index == 0 ? 'checked' : ''?>>
                                    <label for="size_<?=$size->sizeUnique?>" class="fs-14px p-4 d-block rounded text-decoration-none border cursor-pointer"><?=$size->size?></label>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <!-- Color Selection -->
                <?php if($colors && count($colors) > 0): ?>
                    <div class="form-group shop-swatch mb-7 d-flex align-items-center">
                        <span class="fw-semibold text-body-emphasis me-7">Color: </span>
                        <ul class="list-inline d-flex justify-content-start mb-0 flex-wrap">
                            <?php foreach($colors as $index => $color): ?>
                                <li class="list-inline-item me-4 mb-2">
                                    <input type="radio" id="color_<?=$color->colorUnique?>" name="color" value="<?=$color->colorUnique?>" class="product-info-color d-none" <?=$index == 0 ? 'checked' : ''?>>
                                    <label for="color_<?=$color->colorUnique?>" class="d-block rounded-circle border cursor-pointer" style="width: 32px; height: 32px; background-color: <?=$color->colorCode?>;" title="<?=$color->colorName?>"></label>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <!-- Quantity -->
                <div class="form-group mb-7">
                    <span class="fw-semibold text-body-emphasis d-block mb-4">Quantity: </span>
                    <div class="d-flex align-items-center">
                        <div class="quantity-selector d-flex align-items-center border rounded" style="width: fit-content;">
                            <button type="button" class="btn btn-sm px-4 py-2 border-0" onclick="decreaseQty()">-</button>
                            <input type="number" name="quantity" id="productQty" min="1" max="<?=$product->stock ?: 99?>" class="form-control form-control-sm text-center border-0" value="1" style="width: 60px;">
                            <button type="button" class="btn btn-sm px-4 py-2 border-0" onclick="increaseQty()">+</button>
                        </div>
                        <?php if($product->stock): ?>
                            <span class="ms-4 text-muted fs-14px"><?=$product->stock?> in stock</span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Pre-Order Button -->
                <button type="submit" class="btn btn-lg btn-dark mb-7 w-100 btn-hover-bg-primary btn-hover-border-primary">
                    <i class="fas fa-box me-2"></i> Pre-Order Now
                </button>
            </form>
            
            <!-- Wishlist & Compare -->
            <div class="d-flex align-items-center flex-wrap mb-7">
                <a href="#" class="text-decoration-none fw-semibold fs-6 me-9 pe-2 d-flex align-items-center add-to-wishlist" data-product="<?=$product->productUnique?>">
                    <svg class="icon fs-5"><use xlink:href="#icon-heart"></use></svg>
                    <span class="ms-4 ps-2">Add to wishlist</span>
                </a>
            </div>
            
            <!-- Product Meta -->
            <ul class="single-product-meta list-unstyled border-top pt-7 mt-7">
                <?php if($product->productUnique): ?>
                    <li class="d-flex mb-4 pb-2 align-items-center">
                        <span class="text-body-emphasis fw-semibold fs-14px">SKU:</span>
                        <span class="ps-4"><?=strtoupper(substr($product->productUnique, 0, 8))?></span>
                    </li>
                <?php endif; ?>
                <?php if($product->category_name): ?>
                    <li class="d-flex mb-4 pb-2 align-items-center">
                        <span class="text-body-emphasis fw-semibold fs-14px">Category:</span>
                        <span class="ps-4">
                            <a href="<?=base_url('products?category='.$product->categoryUnique)?>" class="text-body"><?=$product->category_name?></a>
                        </span>
                    </li>
                <?php endif; ?>
                <li class="d-flex mb-4 pb-2 align-items-center">
                    <span class="text-body-emphasis fw-semibold fs-14px">Share:</span>
                    <ul class="list-inline d-flex align-items-center mb-0 ps-4">
                        <li class="list-inline-item me-7">
                            <a href="https://twitter.com/intent/tweet?url=<?=urlencode(current_url())?>&text=<?=urlencode($product->name)?>" target="_blank" class="fs-14px text-body" data-bs-toggle="tooltip" data-bs-title="Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                        </li>
                        <li class="list-inline-item me-7">
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?=urlencode(current_url())?>" target="_blank" class="fs-14px text-body" data-bs-toggle="tooltip" data-bs-title="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        </li>
                        <li class="list-inline-item me-7">
                            <a href="https://wa.me/?text=<?=urlencode($product->name . ' - ' . current_url())?>" target="_blank" class="fs-14px text-body" data-bs-toggle="tooltip" data-bs-title="WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</section>

<!-- Product Tabs Section -->
<div class="border-top w-100"></div>
<section class="container pt-15 pb-12 pt-lg-17 pb-lg-20">
    <div class="collapse-tabs">
        <!-- Desktop Tabs -->
        <ul class="nav nav-tabs border-0 justify-content-center pb-12 d-none d-md-flex" id="productTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link m-auto fw-semibold py-0 px-8 fs-4 fs-lg-3 border-0 text-body-emphasis active"
                        id="product-details-tab" data-bs-toggle="tab" data-bs-target="#product-details" type="button"
                        role="tab" aria-controls="product-details" aria-selected="true">Product Details
                </button>
            </li>
            <?php if($product->shipping_policy): ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link m-auto fw-semibold py-0 px-8 fs-4 fs-lg-3 border-0 text-body-emphasis"
                            id="shipping-tab" data-bs-toggle="tab" data-bs-target="#shipping" type="button" role="tab"
                            aria-controls="shipping" aria-selected="false">Shipping
                    </button>
                </li>
            <?php endif; ?>
            <li class="nav-item" role="presentation">
                <button class="nav-link m-auto fw-semibold py-0 px-8 fs-4 fs-lg-3 border-0 text-body-emphasis"
                        id="reviews-tab" data-bs-toggle="tab" data-bs-target="#reviews-section" type="button" role="tab"
                        aria-controls="reviews-section" aria-selected="false">Reviews (<?=$total_reviews?>)
                </button>
            </li>
        </ul>
        
        <!-- Tab Content -->
        <div class="tab-content">
            <div class="tab-inner">
                <!-- Product Details Tab -->
                <div class="tab-pane fade active show" id="product-details" role="tabpanel" aria-labelledby="product-details-tab" tabindex="0">
                    <div class="card border-0 bg-transparent">
                        <div class="card-header border-0 bg-transparent px-0 py-4 product-tabs-mobile d-block d-md-none">
                            <h5 class="mb-0">
                                <button class="btn lh-2 fs-5 py-3 px-6 shadow-none w-100 border text-primary" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#collapse-product-detail"
                                        aria-expanded="true" aria-controls="collapse-product-detail">
                                    Product Details
                                </button>
                            </h5>
                        </div>
                        <div class="collapse show border-md-0 border p-md-0 p-6" id="collapse-product-detail">
                            <div class="row">
                                <div class="col-12">
                                    <?php if($product->description): ?>
                                        <div class="product-description">
                                            <?=$product->description?>
                                        </div>
                                    <?php else: ?>
                                        <p class="text-muted">No detailed description available for this product.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Shipping Tab -->
                <?php if($product->shipping_policy): ?>
                    <div class="tab-pane fade" id="shipping" role="tabpanel" aria-labelledby="shipping-tab" tabindex="0">
                        <div class="card border-0 bg-transparent">
                            <div class="card-header border-0 bg-transparent px-0 py-4 product-tabs-mobile d-block d-md-none">
                                <h5 class="mb-0">
                                    <button class="btn lh-2 fs-5 py-3 px-6 shadow-none w-100 border text-primary collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse-shipping"
                                            aria-expanded="false" aria-controls="collapse-shipping">
                                        Shipping
                                    </button>
                                </h5>
                            </div>
                            <div class="collapse border-md-0 border p-md-0 p-6" id="collapse-shipping">
                                <div class="pb-3">
                                    <?=$product->shipping_policy?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Reviews Tab -->
                <div class="tab-pane fade" id="reviews-section" role="tabpanel" aria-labelledby="reviews-tab" tabindex="0">
                    <div class="card border-0 bg-transparent">
                        <div class="card-header border-0 bg-transparent px-0 py-4 product-tabs-mobile d-block d-md-none">
                            <h5 class="mb-0">
                                <button class="btn lh-2 fs-5 py-3 px-6 shadow-none w-100 border text-primary collapsed" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#collapse-reviews"
                                        aria-expanded="false" aria-controls="collapse-reviews">
                                    Reviews (<?=$total_reviews?>)
                                </button>
                            </h5>
                        </div>
                        <div class="collapse border-md-0 border p-md-0 p-6" id="collapse-reviews">
                            <?php if($reviews && count($reviews) > 0): ?>
                                <div class="reviews-list">
                                    <?php foreach($reviews as $review): ?>
                                        <div class="review-item border-bottom pb-6 mb-6">
                                            <div class="d-flex justify-content-between align-items-start mb-3">
                                                <div>
                                                    <h6 class="mb-1"><?=$review->firstname?> <?=$review->lastname?></h6>
                                                    <div class="d-flex align-items-center fs-12px rating-result">
                                                        <div class="rating">
                                                            <div class="empty-stars">
                                                                <?php for($i = 0; $i < 5; $i++): ?>
                                                                    <span class="star">
                                                                        <svg class="icon star-o"><use xlink:href="#star-o"></use></svg>
                                                                    </span>
                                                                <?php endfor; ?>
                                                            </div>
                                                            <div class="filled-stars" style="width: <?=($review->review_rating / 5) * 100?>%">
                                                                <?php for($i = 0; $i < 5; $i++): ?>
                                                                    <span class="star">
                                                                        <svg class="icon star text-primary"><use xlink:href="#star"></use></svg>
                                                                    </span>
                                                                <?php endfor; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <span class="text-muted fs-14px"><?=date('M d, Y', strtotime($review->reviewDateAdded))?></span>
                                            </div>
                                            <p class="mb-0"><?=$review->review_text?></p>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php else: ?>
                                <p class="text-muted text-center py-6">No reviews yet. Be the first to review this product!</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Products Section -->
<?php if($related_products && count($related_products) > 0): ?>
    <section class="container pb-15 pb-lg-20">
        <h2 class="text-center mb-10">You May Also Like</h2>
        <div class="row justify-content-center">
            <?php foreach($related_products as $related): ?>
                <div class="col-lg-3 col-md-6 mb-9">
                    <div class="card product-card h-100 border-0 bg-transparent">
                        <div class="position-relative overflow-hidden rounded-3 bg-body-secondary" style="padding-top: 125%;">
                            <a href="<?=base_url('products/view/'.$related->slug.'/'.$related->productUnique)?>" class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center">
                                <img src="<?=PRODUCT_ASSETS_URL.$related->image?>" alt="<?=$related->name?>" class="img-fluid object-fit-cover" style="max-height: 100%;">
                            </a>
                            <?php if($related->discount_percentage): ?>
                                <span class="badge bg-primary position-absolute top-0 start-0 m-4"><?=$related->discount_percentage?>% OFF</span>
                            <?php endif; ?>
                        </div>
                        <div class="card-body px-0 pt-6 pb-0 text-center">
                            <h6 class="mb-3">
                                <a href="<?=base_url('products/view/'.$related->slug.'/'.$related->productUnique)?>" class="text-decoration-none text-body-emphasis"><?=$related->name?></a>
                            </h6>
                            <div class="product-price">
                                <?php if($related->discount_percentage): ?>
                                    <span class="text-decoration-line-through text-muted me-2"><?=currency_main_symbol($related->amount, 1)?></span>
                                    <span class="text-body-emphasis fw-bold"><?=currency_main_symbol($related->amount, 1, true, $related->discount_percentage)?></span>
                                <?php else: ?>
                                    <span class="text-body-emphasis fw-bold"><?=currency_main_symbol($related->amount, 1)?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
<?php endif; ?>

<!-- Product Page Scripts -->
<script>
function increaseQty() {
    var input = document.getElementById('productQty');
    var max = parseInt(input.getAttribute('max')) || 99;
    var value = parseInt(input.value) || 1;
    if (value < max) {
        input.value = value + 1;
    }
}

function decreaseQty() {
    var input = document.getElementById('productQty');
    var value = parseInt(input.value) || 1;
    if (value > 1) {
        input.value = value - 1;
    }
}

// Pre-Order Form Submit
$('#preOrderForm').on('submit', function(e) {
    e.preventDefault();
    
    var formData = $(this).serialize();
    
    $.ajax({
        type: 'POST',
        url: '<?=base_url("products/add_to_cart")?>',
        data: formData,
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                // Update cart count
                $('.cart-count').html(response.cart_count);
                
                // Update cart sidebar HTML
                if (response.cart_html) {
                    $('.result-cart').html(response.cart_html);
                }
                
                // Show success toast
                Toastify({
                    text: 'Item added to your pre-order!',
                    duration: 3000,
                    gravity: "top",
                    position: "right",
                    style: { background: "#28a745" },
                }).showToast();
                
                // Optionally open cart sidebar
                var cartOffcanvas = new bootstrap.Offcanvas(document.getElementById('shoppingCart'));
                cartOffcanvas.show();
            } else {
                Toastify({
                    text: response.message,
                    duration: 3000,
                    gravity: "top",
                    position: "right",
                    backgroundColor: "#dc3545",
                }).showToast();
            }
        },
        error: function() {
            Toastify({
                text: 'An error occurred. Please try again.',
                duration: 3000,
                gravity: "top",
                position: "right",
                backgroundColor: "#dc3545",
            }).showToast();
        }
    });
});

// Size & Color selection styling
$('.product-info-size:checked + label, .product-info-color:checked + label').addClass('border-primary');

$('.product-info-size, .product-info-color').on('change', function() {
    var name = $(this).attr('name');
    $('input[name="' + name + '"] + label').removeClass('border-primary');
    $(this).next('label').addClass('border-primary');
});
</script>

