<!-- Breadcrumb Section -->
<section class="z-index-2 position-relative pb-2 mb-12">
    <div class="bg-body-secondary mb-3">
        <div class="container">
            <nav class="py-4 lh-30px" aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center py-1 mb-0">
                    <li class="breadcrumb-item"><a title="Home" href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item"><a title="My Orders" href="<?=base_url('products/my_orders')?>">My Pre-Orders</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Order Details</li>
                </ol>
            </nav>
        </div>
    </div>
</section>

<!-- Order Details Section -->
<section class="container pb-14 pb-lg-19">
    <div class="row">
        <!-- Back Button -->
        <div class="col-12 mb-8">
            <a href="<?=base_url('products/my_orders')?>" class="btn btn-outline-dark">
                <i class="fas fa-arrow-left me-2"></i>Back to My Orders
            </a>
        </div>

        <!-- Order Info -->
        <div class="col-lg-8">
            <!-- Order Header -->
            <div class="card border-0 shadow mb-8">
                <div class="card-body p-8">
                    <div class="d-flex justify-content-between align-items-start flex-wrap">
                        <div class="mb-4 mb-md-0">
                            <h4 class="mb-2">Order <?=$order->orderId?></h4>
                            <p class="text-muted mb-0">
                                <i class="fas fa-calendar me-1"></i> 
                                Placed on <?=date('F j, Y \a\t g:i A', strtotime($order->checkDate))?>
                            </p>
                        </div>
                        <div>
                            <?php
                                $status_classes = [
                                    'pending' => 'bg-warning text-dark',
                                    'processing' => 'bg-info text-white',
                                    'shipped' => 'bg-primary text-white',
                                    'delivered' => 'bg-success text-white',
                                    'cancelled' => 'bg-danger text-white'
                                ];
                                $status_class = isset($status_classes[$order->order_status]) ? $status_classes[$order->order_status] : 'bg-secondary text-white';
                            ?>
                            <span class="badge <?=$status_class?> px-4 py-3 fs-14px text-uppercase"><?=$order->order_status?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Order Progress -->
            <div class="card border-0 shadow mb-8">
                <div class="card-body p-8">
                    <h5 class="mb-6">Order Progress</h5>
                    <div class="order-progress">
                        <?php
                            $statuses = ['pending', 'processing', 'shipped', 'delivered'];
                            $current_index = array_search($order->order_status, $statuses);
                            if ($current_index === false) $current_index = 0;
                        ?>
                        <div class="d-flex justify-content-between position-relative">
                            <?php foreach($statuses as $index => $status): ?>
                                <div class="text-center flex-fill position-relative">
                                    <div class="progress-circle mx-auto mb-3 <?=$index <= $current_index ? 'active' : ''?>" 
                                         style="width: 40px; height: 40px; border-radius: 50%; border: 3px solid <?=$index <= $current_index ? '#198754' : '#dee2e6'?>; background: <?=$index <= $current_index ? '#198754' : '#fff'?>; display: flex; align-items: center; justify-content: center;">
                                        <?php if($index <= $current_index): ?>
                                            <i class="fas fa-check text-white"></i>
                                        <?php else: ?>
                                            <span class="text-muted"><?=$index + 1?></span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mb-0 fs-14px fw-semibold text-uppercase <?=$index <= $current_index ? 'text-success' : 'text-muted'?>"><?=$status?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Order Items -->
            <div class="card border-0 shadow mb-8">
                <div class="card-header bg-body-secondary py-5">
                    <h5 class="mb-0">Order Items</h5>
                </div>
                <div class="card-body p-0">
                    <?php 
                        $subtotal = 0;
                        foreach($order_items as $item): 
                            $item_price = $item->amount;
                            if($item->discount_percentage) {
                                $item_price = $item->amount - ($item->amount * ($item->discount_percentage / 100));
                            }
                            $line_total = $item_price * $item->quantity;
                            $subtotal += $line_total;
                    ?>
                        <div class="d-flex p-6 border-bottom">
                            <div class="flex-shrink-0">
                                <img src="<?=PRODUCT_ASSETS_URL.$item->image?>" width="80" height="100" alt="<?=$item->name?>" class="rounded">
                            </div>
                            <div class="flex-grow-1 ms-6">
                                <h6 class="mb-2"><?=$item->name?></h6>
                                <?php if($item->size): ?>
                                    <p class="mb-1 fs-14px text-muted">Size: <?=$item->size?></p>
                                <?php endif; ?>
                                <?php if($item->colorName): ?>
                                    <p class="mb-1 fs-14px text-muted">Color: <?=$item->colorName?></p>
                                <?php endif; ?>
                                <p class="mb-0 fs-14px">Qty: <?=$item->quantity?></p>
                            </div>
                            <div class="text-end">
                                <?php if($item->discount_percentage): ?>
                                    <p class="mb-0 text-decoration-line-through text-muted fs-14px"><?=currency_main_symbol($item->amount * $item->quantity, 1)?></p>
                                <?php endif; ?>
                                <p class="mb-0 fw-bold"><?=currency_main_symbol($line_total, 1)?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Order Summary Sidebar -->
        <div class="col-lg-4">
            <!-- Payment Info -->
            <div class="card border-0 shadow mb-8">
                <div class="card-header bg-body-secondary py-5">
                    <h5 class="mb-0">Payment Info</h5>
                </div>
                <div class="card-body p-6">
                    <div class="d-flex justify-content-between mb-3">
                        <span>Payment Method:</span>
                        <span class="fw-semibold">
                            <?php
                                $payment_icons = [
                                    'card' => 'Credit Card',
                                    'paypal' => 'PayPal'
                                ];
                                echo isset($payment_icons[$order->payment_method]) ? $payment_icons[$order->payment_method] : ucfirst($order->payment_method);
                            ?>
                        </span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Payment Status:</span>
                        <span class="badge <?=$order->transaction_status == 'completed' ? 'bg-success' : 'bg-warning text-dark'?>"><?=ucfirst($order->transaction_status)?></span>
                    </div>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="card border-0 shadow mb-8">
                <div class="card-header bg-body-secondary py-5">
                    <h5 class="mb-0">Order Summary</h5>
                </div>
                <div class="card-body p-6">
                    <div class="d-flex justify-content-between mb-3">
                        <span>Subtotal:</span>
                        <span class="fw-semibold"><?=currency_main_symbol($order->amount, 1)?></span>
                    </div>
                    <?php if($order->coupon_percentage > 0): ?>
                        <div class="d-flex justify-content-between mb-3 text-success">
                            <span>Discount (<?=$order->coupon_percentage?>%):</span>
                            <span class="fw-semibold">-<?=currency_main_symbol($order->amount - $order->finalAmount, 1)?></span>
                        </div>
                    <?php endif; ?>
                    <?php if($order->delivery_fee > 0): ?>
                        <div class="d-flex justify-content-between mb-3">
                            <span>Shipping:</span>
                            <span class="fw-semibold"><?=currency_main_symbol($order->delivery_fee, 1)?></span>
                        </div>
                    <?php endif; ?>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span class="fs-5 fw-bold">Total:</span>
                        <span class="fs-5 fw-bold text-primary"><?=currency_main_symbol($order->finalAmount, 1)?></span>
                    </div>
                </div>
            </div>

            <!-- Shipping Address -->
            <div class="card border-0 shadow">
                <div class="card-header bg-body-secondary py-5">
                    <h5 class="mb-0">Shipping Address</h5>
                </div>
                <div class="card-body p-6">
                    <p class="mb-0">
                        <strong><?=$order->firstname?> <?=$order->lastname?></strong><br>
                        <?=$order->address?><br>
                        <?=$order->country?><br>
                        <i class="fas fa-phone me-1 mt-3"></i> <?=$order->phone?><br>
                        <i class="fas fa-envelope me-1"></i> <?=$order->email?>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.order-progress::before {
    content: '';
    position: absolute;
    top: 20px;
    left: 10%;
    right: 10%;
    height: 3px;
    background: #dee2e6;
    z-index: -1;
}
</style>

