<!-- Breadcrumb Section -->
<section class="z-index-2 position-relative pb-2 mb-12">
    <div class="bg-body-secondary mb-3">
        <div class="container">
            <nav class="py-4 lh-30px" aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center py-1 mb-0">
                    <li class="breadcrumb-item"><a title="Home" href="<?=base_url()?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">My Pre-Orders</li>
                </ol>
            </nav>
        </div>
    </div>
</section>

<!-- My Orders Section -->
<section class="container pb-14 pb-lg-19">
    <div class="text-center mb-12">
        <h2 class="fs-1">My Pre-Orders</h2>
        <p class="text-muted">View and track all your pre-orders</p>
    </div>

    <?php if($orders && count($orders) > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="bg-dark text-white">
                    <tr>
                        <th class="py-4 ps-6">Order ID</th>
                        <th class="py-4">Date</th>
                        <th class="py-4">Total</th>
                        <th class="py-4">Status</th>
                        <th class="py-4 text-center pe-6">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($orders as $order): ?>
                        <tr>
                            <td class="py-5 ps-6">
                                <span class="fw-semibold text-primary"><?=$order->orderId?></span>
                            </td>
                            <td class="py-5">
                                <?=date('M j, Y', strtotime($order->checkDate))?>
                                <br>
                                <small class="text-muted"><?=date('g:i A', strtotime($order->checkDate))?></small>
                            </td>
                            <td class="py-5">
                                <span class="fw-bold"><?=currency_main_symbol($order->finalAmount, 1)?></span>
                            </td>
                            <td class="py-5">
                                <?php
                                    $status_classes = [
                                        'pending' => 'bg-warning text-dark',
                                        'processing' => 'bg-info text-white',
                                        'shipped' => 'bg-primary text-white',
                                        'delivered' => 'bg-success text-white',
                                        'cancelled' => 'bg-danger text-white'
                                    ];
                                    $status_class = isset($status_classes[$order->order_status]) ? $status_classes[$order->order_status] : 'bg-secondary text-white';
                                ?>
                                <span class="badge <?=$status_class?> px-3 py-2 text-uppercase"><?=$order->order_status?></span>
                            </td>
                            <td class="py-5 text-center pe-6">
                                <a href="<?=base_url('products/order_details/'.$order->transactionUnique)?>" class="btn btn-sm btn-outline-dark">
                                    <i class="fas fa-eye me-1"></i> View Details
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="text-center py-20">
            <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" fill="currentColor" class="text-muted mb-8" viewBox="0 0 16 16">
                <path d="M0 2.5A.5.5 0 0 1 .5 2H2a.5.5 0 0 1 .485.379L2.89 4H14.5a.5.5 0 0 1 .485.621l-1.5 6A.5.5 0 0 1 13 11H4a.5.5 0 0 1-.485-.379L1.61 3H.5a.5.5 0 0 1-.5-.5zM3.14 5l1.25 5h8.22l1.25-5H3.14zM5 13a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0zm9-1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0z"/>
            </svg>
            <h3 class="mb-4">No Pre-Orders Yet</h3>
            <p class="text-muted mb-8 fs-18px">You haven't placed any pre-orders yet.</p>
            <a href="<?=base_url('products')?>" class="btn btn-dark btn-lg px-12">
                <i class="fas fa-shopping-bag me-2"></i>Start Shopping
            </a>
        </div>
    <?php endif; ?>
</section>

