<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users_m extends MY_Model {

    protected $table = 'users';
    protected $primary_key = 'userId';

    public function __construct() {
        parent::__construct();
    }

    /**
     * Get user by verification link
     */
    public function getByVerificationLink($verification_link) {
        return $this->db->where('verification_link', $verification_link)
                        ->where('deleted', 0)
                        ->get($this->table)->row();
    }

    /**
     * Get user by email
     */
    public function getByEmail($email) {
        return $this->db->where('email', $email)
                        ->where('deleted', 0)
                        ->get($this->table)->row();
    }

    /**
     * Get user by unique
     */
    public function getByUnique($userUnique) {
        return $this->db->where('userUnique', $userUnique)
                        ->where('deleted', 0)
                        ->get($this->table)->row();
    }

    /**
     * Register a new user
     */
    public function register($data) {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    /**
     * Update user profile
     */
    public function updateProfile($userId, $data) {
        return $this->db->where('userId', $userId)->update($this->table, $data);
    }

    /**
     * Verify user email
     */
    public function verifyEmail($verification_link) {
        return $this->db->where('verification_link', $verification_link)
                        ->update($this->table, ['status' => 1]);
    }

    /**
     * Update last login
     */
    public function updateLastLogin($userId) {
        return $this->db->where('userId', $userId)
                        ->update($this->table, ['last_login' => date('Y-m-d h:ia')]);
    }

    /**
     * Update OTP
     */
    public function updateOtp($userId, $otp) {
        return $this->db->where('userId', $userId)
                        ->update($this->table, ['otp' => $otp]);
    }

    /**
     * Reset password
     */
    public function resetPassword($userId, $password) {
        return $this->db->where('userId', $userId)
                        ->update($this->table, ['password' => $password, 'otp' => '']);
    }
}

