<?php

if(!function_exists("country_getter")){
	function country_getter(){
		// Set default currency to USD
		$_SESSION['ip_currency'] = "USD";
		$_SESSION['ip_country'] = "United States";

		// Try to detect country from IP (optional)
		try {
			if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
				$ip = $_SERVER['HTTP_CLIENT_IP'];
			} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
				$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			} else {
				$ip = $_SERVER['REMOTE_ADDR'];
			}

			// Only try to get geo info if not localhost
			if ($ip != '127.0.0.1' && $ip != '::1') {
				$xml = @simplexml_load_file("http://www.geoplugin.net/xml.gp?ip=".$ip);
				if ($xml && $xml->geoplugin_countryName) {
					$_SESSION['ip_country'] = (string)$xml->geoplugin_countryName;
				}
			}
		} catch (Exception $e) {
			// Keep defaults if geo detection fails
		}

		$cookie_name = "ip_currency";
		$cookie_value = $_SESSION['ip_currency'];
		setcookie($cookie_name, $cookie_value, time() + (86400 * 365), "/");
	}
}

if(!function_exists("currency"))
{

	function currency($amount, $hasDiscount = false, $discount = 0, $hasCoupon = false, $coupon = 0)
	{
		$CI = get_instance();
		$CI->load->model('settings_m');

		// Default currency is USD
		$default_currency = "USD";
		$rate = 1;

		// Get currency symbol from database, fallback to $ if not found
		$currency = $CI->settings_m->getOneCurrency(array('currency' => $default_currency));
		$symbol = $currency ? $currency->symbol : '$';

		if($hasDiscount == true && $discount > 0){
			$amountDiscount = ($discount/100) * $amount;
			$amount = $amount - $amountDiscount;
		}

		if($hasCoupon == true && $coupon > 0){
			$amountCoupon = ($coupon/100) * $amount;
			$amount = $amount - $amountCoupon;
		}

		$amount = $amount * $rate;
		$formatted = number_format(floor($amount*100)/100, 2);
		
		return $symbol.$formatted;
	}

}

if(!function_exists("currency_symbol_converted"))
{

	function currency_symbol_converted($amount, $hasDiscount = false, $discount = 0, $hasCoupon = false, $coupon = 0)
	{
		$CI = get_instance();
		$CI->load->model('settings_m');

		// Default currency is USD
		$default_currency = "USD";
		
		$currency = $CI->settings_m->getOneCurrency(array('currency' => $default_currency));
		$symbol = $currency ? $currency->symbol : '$';

		if($hasDiscount == true && $discount > 0){
			$amountDiscount = ($discount/100) * $amount;
			$amount = $amount - $amountDiscount;
		}

		if($hasCoupon == true && $coupon > 0){
			$amountCoupon = ($coupon/100) * $amount;
			$amount = $amount - $amountCoupon;
		}

		return $symbol.number_format($amount, 2);
	}

}

if(!function_exists("currency_symbol_converted_float"))
{

	function currency_symbol_converted_float($amount, $hasDiscount = false, $discount = 0, $hasCoupon = false, $coupon = 0)
	{
		if($hasDiscount == true && $discount > 0){
			$amountDiscount = ($discount/100) * $amount;
			$amount = $amount - $amountDiscount;
		}

		if($hasCoupon == true && $coupon > 0){
			$amountCoupon = ($coupon/100) * $amount;
			$amount = $amount - $amountCoupon;
		}

		return (float)number_format($amount, 2, '.', '');
	}

}

if(!function_exists("currencyCoupon"))
{

	function currencyCoupon($amount, $coupon = 0)
	{
		$CI = get_instance();
		$CI->load->model('settings_m');

		$default_currency = "USD";
		$currency = $CI->settings_m->getOneCurrency(array('currency' => $default_currency));
		$symbol = $currency ? $currency->symbol : '$';

		if($coupon > 0){
			$amount = ($coupon/100) * $amount;
		}

		return $symbol.number_format($amount, 2);
	}

}

if(!function_exists("currency_float"))
{

	function currency_float($amount, $hasDiscount = false, $discount = 0, $hasCoupon = false, $coupon = 0)
	{
		if($hasDiscount == true && $discount > 0){
			$amountDiscount = ($discount/100) * $amount;
			$amount = $amount - $amountDiscount;
		}

		if($hasCoupon == true && $coupon > 0){
			$amountCoupon = ($coupon/100) * $amount;
			$amount = $amount - $amountCoupon;
		}

		return (float)number_format($amount, 2, '.', '');
	}

}

if(!function_exists("currency_float_to_USD"))
{

	function currency_float_to_USD($amount)
	{
		// Already in USD, just return formatted

		$default_currency = "USD";
		$rate = 1;
		
		$amount = $amount / $rate;
		return (float)number_format($amount, 2, '.', '');
	}

}

if(!function_exists("payment_currency"))
{

	function payment_currency()
	{
		$CI = get_instance();
		$CI->load->model('settings_m');

		$default_currency = "USD";
		$currency = $CI->settings_m->getOneCurrency(array('currency' => $default_currency));
		return $currency ? $currency->currency : 'USD';
	}

}

if(!function_exists("payment_currency_pay"))
{

	function payment_currency_pay()
	{
		$CI = get_instance();
		$CI->load->model('settings_m');

		$default_currency = "USD";
		$currency = $CI->settings_m->getOneCurrency(array('currency' => $default_currency));
		return $currency ? $currency->payment : 'USD';
	}

}

if(!function_exists("default_currency"))
{

	function default_currency()
	{
		return "USD";
	}

}

if(!function_exists("hashNode"))
{

	function hashNode($string)
	{
    if($string){
			return hash("sha512", $string . config_item("encryption_key"));
		}else{
			return NULL;
		}
	}

}

if(!function_exists("getUserUnique"))
{
	function getUserUnique()
	{
		// Check if user is logged in
		if(isset($_SESSION['login']) && isset($_SESSION['login']->verification_link) && $_SESSION['login']->verification_link){
			return $_SESSION['login']->verification_link;
		}
		
		// Check for existing guest cookie
		if(isset($_COOKIE['userUnique']) && !empty($_COOKIE['userUnique'])){
			return $_COOKIE['userUnique'];
		}
		
		// Generate new guest identifier
		$CI = get_instance();
		$CI->load->library('unique');
		$userUnique = Unique::generate();
		
		// Set cookie for 1 year
		setcookie('userUnique', $userUnique, time() + (86400 * 365), '/');
		$_COOKIE['userUnique'] = $userUnique;
		
		return $userUnique;
	}
}


?>
