<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Base Model Class
 * Provides common CRUD operations for all models
 */
class MY_Model extends CI_Model {

    protected $table;
    protected $primary_key = 'id';

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Get all records from table
     */
    public function getAll($order_by = null, $order = 'DESC') {
        if ($order_by) {
            $this->db->order_by($order_by, $order);
        }
        return $this->db->get($this->table)->result();
    }

    /**
     * Get single record by primary key
     */
    public function get($id) {
        return $this->db->where($this->primary_key, $id)->get($this->table)->row();
    }

    /**
     * Get single record by conditions
     */
    public function getOne($where) {
        return $this->db->where($where)->get($this->table)->row();
    }

    /**
     * Get multiple records by conditions
     */
    public function getWhere($where, $order_by = null, $order = 'DESC') {
        if ($order_by) {
            $this->db->order_by($order_by, $order);
        }
        return $this->db->where($where)->get($this->table)->result();
    }

    /**
     * Get records with filter and join
     */
    public function getFilter($where, $order_by = null, $order = 'DESC', $limit = null) {
        if ($order_by) {
            $this->db->order_by($order_by, $order);
        }
        if ($limit) {
            $this->db->limit($limit);
        }
        return $this->db->where($where)->get($this->table)->result();
    }

    /**
     * Get records with limit
     */
    public function getLimit($limit, $order_by = null, $order = 'DESC') {
        if ($order_by) {
            $this->db->order_by($order_by, $order);
        }
        $this->db->limit($limit);
        return $this->db->get($this->table)->result();
    }

    /**
     * Insert a new record
     */
    public function insert($data) {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    /**
     * Update a record by primary key
     */
    public function update($id, $data) {
        return $this->db->where($this->primary_key, $id)->update($this->table, $data);
    }

    /**
     * Update records by conditions
     */
    public function updateWhere($where, $data) {
        return $this->db->where($where)->update($this->table, $data);
    }

    /**
     * Delete a record by primary key
     */
    public function delete($id) {
        return $this->db->where($this->primary_key, $id)->delete($this->table);
    }

    /**
     * Delete records by conditions
     */
    public function deleteWhere($where) {
        return $this->db->where($where)->delete($this->table);
    }

    /**
     * Count all records
     */
    public function countAll() {
        return $this->db->count_all($this->table);
    }

    /**
     * Count records by conditions
     */
    public function countWhere($where) {
        return $this->db->where($where)->count_all_results($this->table);
    }
}

